/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	AddComponent.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cAssembly.h"
#include "cApplication.h"

using namespace ProDESKTOPLib;
HRESULT AddComponent(CString strfileName, IDesign **component)
{

//	Adds the component specified as strfileName (input as CString )
//	into Active Part and returns the component .

	START_METHOD("Add Component")

    HRESULT status = CONV_SUCCESS;
	IDispatch *pDisp = NULL;
	
	long count;
	BSTR str;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *design = NULL;
	status = activePart->OpenDesign(strfileName.AllocSysString(),&design);
	CHECK_RETURN_STATUS(status)
	
	IVector *pLocalOrigin = NULL;

	// get the origin
	status = activeWorkplane->GetLocalOrigin(&pLocalOrigin);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalX = NULL;
	status = activeWorkplane->GetLocalX(&pLocalX);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalY = NULL;
	status = activeWorkplane->GetLocalY(&pLocalY);
	CHECK_RETURN_STATUS(status)

	IMatrix *pTemp1 = NULL;
	status = (GetCLASS(Matrix))->CreateTranslationMatrix(pLocalOrigin, &pTemp1);
	CHECK_RETURN_STATUS(status)

	IMatrix *pTemp2 = NULL;
	status = (GetCLASS(Matrix))->CreateRotationMatrix(pLocalX, pLocalY, &pTemp2);
	CHECK_RETURN_STATUS(status)

	// multiply the matrix
	IMatrix *pTranslation = NULL;
	status = pTemp1->MultiplyByMatrix(pTemp2, &pTranslation);
	CHECK_RETURN_STATUS(status)

	ISet *workplaneSet = NULL;
	status = design->GetWorkplanes(&workplaneSet);
	CHECK_RETURN_STATUS(status)

	status = workplaneSet->GetCount(&count);
	CHECK_RETURN_STATUS(status)

	IDispatch *pCurrentWorkplane = NULL;
	IWorkplane *currentWorkplane = NULL;

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(workplaneSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	// loop to get base workplane
	status = pObjectIt->start(&pCurrentWorkplane);
    while (pCurrentWorkplane) {
		currentWorkplane = CAST(IWorkplane, pCurrentWorkplane);

        status = currentWorkplane->GetName(&str);
		CHECK_RETURN_STATUS(status)
		CString str1(str);

		IVector *pCurrrentOrigin = NULL;

		// if current work plane is base one
		if (strcmp(str1,"base") == 0){
			status = currentWorkplane->GetLocalOrigin(&pCurrrentOrigin);
			CHECK_RETURN_STATUS(status)
			
			IDirection *pCurrentX = NULL;
			IDirection *pCurrentY = NULL;

			status = currentWorkplane->GetLocalX(&pCurrentX);
			CHECK_RETURN_STATUS(status)

			status = currentWorkplane->GetLocalY(&pCurrentY);
			CHECK_RETURN_STATUS(status)

			IMatrix *matrix = NULL;
            status = (GetCLASS(Matrix))->CreateTranslationMatrix(pCurrrentOrigin, &matrix);
			CHECK_RETURN_STATUS(status)

			IMatrix *pTemp4 = NULL;
            status = (GetCLASS(Matrix))->CreateRotationMatrix(pCurrentX, pCurrentY, &pTemp4);
			CHECK_RETURN_STATUS(status)

			IMatrix *pOldMapping = NULL;

			status = matrix->MultiplyByMatrix(pTemp4, &pOldMapping);
			CHECK_RETURN_STATUS(status)

			IMatrix *pInverse = NULL;
			// find inverse
			status = pOldMapping->GetInverse(&pInverse);
			CHECK_RETURN_STATUS(status)

			// multiply matrix
			IMatrix *matrix2 = NULL;
			status = pTranslation->MultiplyByMatrix(pInverse, &matrix2);
			CHECK_RETURN_STATUS(status)

            break;
		}
		pCurrentWorkplane = NULL;
			pObjectIt->Next(&pCurrentWorkplane);

    }

	IDesign *design1= NULL;
	// get the design component
	status = activePart->GetDesign(&design1);
	CHECK_RETURN_STATUS(status)

	// Create component
	IDesign *comp = NULL;
    status = design1->CreateComponent(design, pTranslation, &comp);
	CHECK_RETURN_STATUS(status)
	*component = comp;

	END_METHOD("Add Component")
}
